﻿// *******************************
// Fragmenty kodu z rozdziału 8.
// *******************************
// Aby skorzystać z przykładów, skopiuj odpowiedni kod
// do panelu Actions (Operacje) w pustym projekcie Flasha.
// *******************************


// *******************************
// Podrozdział Tworzenie własnego programu ładującego
// *******************************

// -------------------------------
// Własny program ładujący 1
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
intervalID = setInterval(monitorProgress, 100);

function monitorProgress() : Void
{
    var percentDone:Number;
    percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
    trace("Załadowano: " + percentDone);
    if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
    {
        clearInterval(intervalID);
        trace("Zakończono ładowanie zawartości.");
    }
}
// -------------------------------

// -------------------------------
// Własny program ładujący 2
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
intervalID = setInterval(monitorProgress, 100);

function monitorProgress() : Void
{
    var percentDone:Number;
    if (myMovie.getBytesLoaded() > 0)
    {
        percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
        trace("Załadowano: " + percentDone);
        if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
        {
            clearInterval(intervalID);
            trace("Zakończono ładowanie zawartości.");
        }
    }
}
// -------------------------------

// -------------------------------
// Własny program ładujący 3
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
intervalID = setInterval(monitorProgress, 100);

function monitorProgress() : Void
{
    var percentDone:Number;
    myMovie.stop();
    myMovie._visible = false;
    if (myMovie.getBytesLoaded() > 0)
    {
        percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
        trace("percentDone: " + percentDone);
        if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
        {
            clearInterval(intervalID);
            myMovie.play();
            myMovie._visible = true;
            trace("Zakończono ładowanie zawartości.");
        }
    }
}
// -------------------------------

// -------------------------------
// Custom preloader snippet 4
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
intervalID = setInterval(monitorProgress, 100);

function monitorProgress() : Void
{
    var percentDone:Number;
    myMovie.stop();
    myMovie._visible = false;
    if (myMovie.getBytesLoaded() > 0)
    {
        percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
        showProgress(percentDone);
        trace("Załadowano: " + percentDone);
        if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
        {
            clearInterval(intervalID);
            myMovie.play();
            myMovie._visible = true;
            progressMovie._visible = false;
            trace("Zakończono ładowanie zawartości.");
        }
    }
}

function showProgress(percentDone:Number) : Void
{
    var barWidth:Number = percentDone;
    progressMovie.percentDoneLabel.text = String(Math.ceil(percentDone)) + " %";
    progressMovie.clear();
        
    // Rysowanie obramowania.
    progressMovie.moveTo(0, 20);
    progressMovie.lineStyle(1, 0x666666);
    progressMovie.lineTo(100, 20);
    progressMovie.lineTo(100, 30);
    progressMovie.lineTo(0, 30);
    progressMovie.lineTo(0, 20);
    
    // Rysowanie paska postępu.
    progressMovie.moveTo(0, 20);
    progressMovie.beginFill(0xCCCCCC, 100);
    progressMovie.lineTo(barWidth, 20);
    progressMovie.lineTo(barWidth, 30);
    progressMovie.lineTo(0, 30);
    progressMovie.lineTo(0, 20);
    progressMovie.endFill();
}
// -------------------------------

// -------------------------------
// Custom preloader snippet 5
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
intervalID = setInterval(monitorProgress, 100, progressMovie, showProgress);

function monitorProgress(progressBarHolder:MovieClip, progressUpdater:Function) : Void
{
    var percentDone:Number;
    myMovie.stop();
    myMovie._visible = false;
    if (myMovie.getBytesLoaded() > 0)
    {
        percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
        progressUpdater(percentDone, progressBarHolder);
        trace("Załadowano: " + percentDone);
        if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
        {
            clearInterval(intervalID);
            myMovie.play();
            myMovie._visible = true;
            progressBarHolder._visible = false;
            trace("Zakończono ładowanie zawartości.");
        }
    }
}

function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    
    progressBarHolder._visible = true;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();
        
    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    
    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
// -------------------------------

// -------------------------------
// Własny program ładujący wersja onEnterFrame
var intervalID:Number;

this.createEmptyMovieClip("myMovie", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

myMovie.loadMovie("http://www.nathanderksen.com/book/trailer.swf");
this.onEnterFrame = function()
{
    monitorProgress(this, progressMovie, showProgress);
}

function monitorProgress(contentHolder:MovieClip, progressBarHolder:MovieClip, progressUpdater:Function) : Void
{
    var percentDone:Number;
    myMovie.stop();
    myMovie._visible = false;
    if (myMovie.getBytesLoaded() > 0)
    {
        percentDone = myMovie.getBytesLoaded() / myMovie.getBytesTotal() * 100;
        progressUpdater(percentDone, progressBarHolder);
        trace("Załadowano: " + percentDone);
        if (myMovie.getBytesTotal() == myMovie.getBytesLoaded())
        {
            clearInterval(intervalID);
            myMovie.play();
            myMovie._visible = true;
            progressBarHolder._visible = false;
            delete contentHolder.onEnterFrame;
            trace("Zakończono ładowanie zawartości.");
        }
    }
}

function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    
    progressBarHolder._visible = true;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();
        
    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    
    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
// -------------------------------

// -------------------------------
// metoda addListener
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

var loadListener:Object = new Object();
loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    trace("Zakończono ładowanie zawartości.");
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("section1.swf", sectionHolder);
// -------------------------------

// -------------------------------
// metoda getProgress
var contentLoader:MovieClipLoader = new MovieClipLoader();

this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

function checkProgress()
{
    var statusObject:Object = contentLoader.getProgress(contentHolder);
    trace("bytes loaded: " + statusObject.bytesLoaded);
    trace("bytes total: " + statusObject.bytesTotal);
}

setInterval(checkProgress, 50);
contentLoader.loadClip("section1.swf", sectionHolder);
// -------------------------------

// -------------------------------
// metoda loadClip
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

var loadListener:Object = new Object();
loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    trace("Zakończono ładowanie zawartości.");
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("section1.swf", sectionHolder);
// -------------------------------

// -------------------------------
// metoda removeListener
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

var loadListener:Object = new Object();
loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
    var percentDone:Number = bytesLoaded / bytesTotal * 100;
    if (percentDone > 50)
    {
        contentHolder.play();
        contentLoader.removeListener(this);
    }
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("section1.swf", sectionHolder);
// -------------------------------

// -------------------------------
// metoda unloadClip
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.loadClip("section1.swf", sectionHolder);

cancelButton.onRelease = function()
{
    contentLoader.unloadClip(sectionHolder);
};
// -------------------------------


// -------------------------------
// klasa MovieClipLoader 1
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("http://www.nathanderksen.com/book/trailer.swf", sectionHolder);
// -------------------------------

// -------------------------------
// klasa MovieClipLoader 2
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("http://www.nathanderksen.com/book/trailer.swf", sectionHolder);
     
function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();

    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);

    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
// -------------------------------

// -------------------------------
// Klasa MovieClipLoader 3
this.createEmptyMovieClip("sectionHolder", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
    progressMovie._visible = true;
    contentHolder._visible = false;
    contentHolder.stop();
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
    var percentDone:Number = bytesLoaded / bytesTotal * 100;
    showProgress(percentDone, progressMovie);
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    progressMovie._visible = false;
    contentHolder._visible = true;
    contentHolder.play();
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("http://www.nathanderksen.com/book/trailer.swf", sectionHolder);
     
function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();
   
    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);

    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
// -------------------------------

// -------------------------------
// Komponent Loader 1
this.createClassObject(mx.controls.Loader, "loaderComponent", this.getNextHighestDepth());
this.createClassObject(mx.controls.ProgressBar, "progressComponent", this.getNextHighestDepth());
progressComponent._x = 50;
progressComponent._y = 100;
// -------------------------------

// -------------------------------
// Komponent Loader 2
this.createClassObject(mx.controls.Loader, "loaderComponent", this.getNextHighestDepth());
this.createClassObject(mx.controls.ProgressBar, "progressComponent", this.getNextHighestDepth());
progressComponent._x = 50;
progressComponent._y = 100;

progressComponent.source = loaderComponent;
loaderComponent.scaleContent = false;
loaderComponent.load("http://www.nathanderksen.com/book/trailer.swf");
// -------------------------------

// -------------------------------
// Komponent Loader 3
this.createClassObject(mx.controls.Loader, "loaderComponent", this.getNextHighestDepth());
this.createClassObject(mx.controls.ProgressBar, "progressComponent", this.getNextHighestDepth());
progressComponent._x = 50;
progressComponent._y = 100;

var loadHandler:Object = new Object();
loadHandler.progress = function(eventObject:Object)
{
    loaderComponent.content.stop();
}

loadHandler.complete = function(eventObject:Object)
{
    loaderComponent.content.play();
    progressComponent._visible = false;
}

progressComponent.source = loaderComponent;
loaderComponent.scaleContent = false;
loaderComponent.addEventListener("progress", loadHandler);
loaderComponent.addEventListener("complete", loadHandler);
loaderComponent.load("http://www.nathanderksen.com/book/trailer.swf");
// -------------------------------


// *******************************
// Ćwiczenia
// *******************************

// -------------------------------
// Ćwiczenie 2
this.createEmptyMovieClip("movieHolder", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 100, 20);

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
    progressMovie._visible = true;
    contentHolder._visible = false;
    contentHolder.stop();
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
    var percentDone:Number = bytesLoaded / bytesTotal * 100;
    showProgress(percentDone, progressMovie);
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    progressMovie._visible = false;
    contentHolder._visible = true;
    contentHolder.play();
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("exercise1Trailer.swf", movieHolder);
     
function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();
   
    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);

    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
// -------------------------------
